-- --------------------------------------------------------------------------
-- Copyright  2008 PlayFirst, Inc. All Rights Reserved.
--
-- This material is the confidential trade secret and proprietary
-- information of PlayFirst, Inc. It may not be reproduced, used, disclosed,
-- sold or transferred without the prior written consent of PlayFirst, Inc. 
-- All rights reserved.
-- --------------------------------------------------------------------------
dofile( "scripts/help_style.lua" );



nameDialog = "help6";
HeaderTittle = "help_header_requests";
BoxName			= "images/ui/buttons/box07";

asset1 = "images/ui/help/bubble_icons_0001";
asset2 = "images/ui/help/normal_0001";
asset3 = "images/ui/help/toolkit_0001";
asset4 = "images/ui/help/tv_help_icons";
asset5 = "images/ui/help/tutorial_sweat_01";
assetbubble = "images/ui/help/request_bubble";

Box1Tx = "help_requests_text_1_header";
Box2Tx = "help_requests_text_2_header";
Box3Tx = "help_requests_text_3_header";
Box4Tx = "help_requests_text_4_header";
Box5Tx = "help_requests_text_5_header";

definition1Tx = "help_requests_text_1";
definition2Tx = "help_requests_text_2";
definition3Tx = "help_requests_text_3";
definition4Tx = "help_requests_text_4";
definition5Tx = "help_requests_text_5";

paginateLabel = "help_paginate_6";

function BackCommand() 
	SwapToModal("scripts/help5.lua");
end

function NextCommand() 
	SwapToModal("scripts/help7.lua");
end

MakeDialog
{
	-- Name the modal dialog
	name = nameDialog,
	Bitmap
	{
		image="images/backgrounds/bgpopup01",
		x=kCenter,
		y=kCenter,
		
		Bitmap
		{
			image="images/ui/common/popup05",
			x=0,
			y=0,
		};
--Tittle
		Text
		{
			font = BigPopupFont,
			x=kCenter,
			y=kTitleY,
			w=kMax,h=45,
			flags = kHAlignCenter + kVAlignCenter,
			label = "help",
		};
--Header
		Text
		{
			font = PopupFont,
			x=kTextHeaderX,
			y=kTextHeaderY,
			w=kMax,h=45,
			flags = kHAlignLeft + kVAlignCenter,
			label = HeaderTittle,
		};
--Line 1
		Bitmap
		{
			image=BoxName,
			x=kFirstRow,
			y=kFirstLine,
			Bitmap
			{
				image=assetbubble,
				x=4,
				y=4,
				
				Bitmap
				{
					image=asset1,
					x=15,
					y=3,
				};
			};
		};
		
--Machine1 Name
		Bitmap
		{
			image="images/ui/buttons/box02",
			x=kFirstRow+kRowSpace2,
			y=kFirstLine,
	
			Text
			{
				font = MachineFont,
				x=5,
				y=3,
				w=kMax,h=20,
				flags = kHAlignLeft + kVAlignCenter,
				label = Box1Tx,
			};
		};
		SetStyle(HelpTxDefStyle2),
		Text
		{
			x=kFirstRow+kRowSpace2,
			y=kFirstLine+kTextSpaceUnderBox,
			label = definition1Tx,
		};
--Line 2
		Bitmap
		{
			image=BoxName,
			x=kFirstRow,
			y=kFirstLine+kLineSpace2,
			Bitmap
			{
				image=assetbubble,
				x=4,
				y=4,
				Bitmap
				{
					image=asset2,
					x=12,
					y=0,
					scale = 1.2,
				};
			};
		};
--Machine2 Name
		Bitmap
		{
			image="images/ui/buttons/box02",
			x=kFirstRow+kRowSpace2,
			y=kFirstLine+kLineSpace2,
	
			Text
			{
				font = MachineFont,
				x=5,
				y=3,
				w=kMax,h=20,
				flags = kHAlignLeft + kVAlignCenter,
				label = Box2Tx,
			};
		};
		Text
		{
			x=kFirstRow+kRowSpace2,
			y=kFirstLine+kTextSpaceUnderBox+kLineSpace2,
			label = definition2Tx,
		};
--Line 3
		Bitmap
		{
			image=BoxName,
			x=kFirstRow,
			y=kFirstLine+2*kLineSpace2,
			Bitmap
			{
				image=assetbubble,
				x=4,
				y=4,
				Bitmap
				{
					image=asset3,
					x=12,
					y=5,
					scale = 1.2,
				};
			};
		};
--Machine3 Name
		Bitmap
		{
			image="images/ui/buttons/box02",
			x=kFirstRow+kRowSpace2,
			y=kFirstLine+2*kLineSpace2,
	
			Text
			{
				font = MachineFont,
				x=5,
				y=3,
				w=kMax,h=20,
				flags = kHAlignLeft + kVAlignCenter,
				label = Box3Tx,
			};
		};
		Text
		{
			x=kFirstRow+kRowSpace2,
			y=kFirstLine+kTextSpaceUnderBox+2*kLineSpace2,
			label = definition3Tx,
		};
--Line 4
		Bitmap
		{
			image=BoxName,
			x=kFirstRow,
			y=kFirstLine+3*kLineSpace2,
			Bitmap
			{
				image=assetbubble,
				x=4,
				y=4,
				Bitmap
				{
					image=asset4,
					x=7,
					y=0,
					scale = 0.8,
				};
			};
		};
--Machine4 Name
		Bitmap
		{
			image="images/ui/buttons/box02",
			x=kFirstRow+kRowSpace2,
			y=kFirstLine+3*kLineSpace2,
	
			Text
			{
				font = MachineFont,
				x=5,
				y=3,
				w=kMax,h=20,
				flags = kHAlignLeft + kVAlignCenter,
				label = Box4Tx,
			};
		};
		Text
		{
			x=kFirstRow+kRowSpace2,
			y=kFirstLine+kTextSpaceUnderBox+3*kLineSpace2,
			label = definition4Tx,
		};
--Line 5
		Bitmap
		{
			image=BoxName,
			x=kFirstRow,
			y=kFirstLine+4*kLineSpace2,
			Bitmap
			{
				image=asset5,
				x=2,
				y=0,
				scale = 0.9,
			};
		};
--5 Name
		Bitmap
		{
			image="images/ui/buttons/box02",
			x=kFirstRow+kRowSpace2,
			y=kFirstLine+4*kLineSpace2,
	
			Text
			{
				font = MachineFont,
				x=5,
				y=3,
				w=kMax,h=20,
				flags = kHAlignLeft + kVAlignCenter,
				label = Box5Tx,
			};
		};
		Text
		{
			x=kFirstRow+kRowSpace2,
			y=kFirstLine+kTextSpaceUnderBox+4*kLineSpace2,
			label = definition5Tx,
		};
		SetStyle(FitnessButtonStyleTittleSmallBlue),
--//Back
		SBButton
		{
			x=kButtonX,
			y=kButtonY,
			
			icon="assets/images/ui/buttons/icon/iconback",
			command=
				function()
					-- Our game provides this call--it's not a Playground
					-- call.
                    BackCommand();
				end
		},
		Text
		{
			font = SmallFont,
			x=kButtonX,
			y=kButtonY+kTextY,
			flags = kHAlignCenter + kVAlignCenter,
			label = "common.back.label",
		};
--Next
		SBButton
		{
			x=kButtonX+kButtonSpaceX,
			y=kButtonY,
			
			icon="assets/images/ui/buttons/icon/iconplay",
			command=
				function()
					-- Our game provides this call--it's not a Playground
					-- call.
                    NextCommand();
				end
		},
		Text
		{
			font = SmallFont,
			x=kButtonX+kButtonSpaceX,
			y=kButtonY+kTextY,
			flags = kHAlignCenter + kVAlignCenter,
			label = "next",
		};
--Paginate
		Text
		{
			font = SmallFontBlack,
			flags = kHAlignCenter + kVAlignCenter,
			x=kPaginateX,
			y=kPaginateY,
			w=kMax,h=30,
			
			label = paginateLabel,
		};
	}
}

